import { StateNode } from "@tldraw/editor";
import { CursorTypeMap } from "../../PointingResizeHandle.mjs";
class PointingCropHandle extends StateNode {
  static id = "pointing_crop_handle";
  info = {};
  onEnter = (info) => {
    this.info = info;
    this.parent.setCurrentToolIdMask(info.onInteractionEnd);
    const selectedShape = this.editor.getSelectedShapes()[0];
    if (!selectedShape) return;
    const cursorType = CursorTypeMap[this.info.handle];
    this.editor.setCursor({ type: cursorType, rotation: this.editor.getSelectionRotation() });
    this.editor.setCroppingShape(selectedShape.id);
  };
  onExit = () => {
    this.editor.setCursor({ type: "default", rotation: 0 });
    this.parent.setCurrentToolIdMask(void 0);
  };
  onPointerMove = () => {
    if (this.editor.inputs.isDragging) {
      this.startCropping();
    }
  };
  onLongPress = () => {
    this.startCropping();
  };
  startCropping() {
    if (this.editor.getInstanceState().isReadonly) return;
    this.parent.transition("cropping", {
      ...this.info,
      onInteractionEnd: this.info.onInteractionEnd
    });
  }
  onPointerUp = () => {
    if (this.info.onInteractionEnd) {
      this.editor.setCurrentTool(this.info.onInteractionEnd, this.info);
    } else {
      this.editor.setCroppingShape(null);
      this.editor.setCurrentTool("select.idle");
    }
  };
  onCancel = () => {
    this.cancel();
  };
  onComplete = () => {
    this.cancel();
  };
  onInterrupt = () => {
    this.cancel();
  };
  cancel() {
    if (this.info.onInteractionEnd) {
      this.editor.setCurrentTool(this.info.onInteractionEnd, this.info);
    } else {
      this.editor.setCroppingShape(null);
      this.editor.setCurrentTool("select.idle");
    }
  }
}
export {
  PointingCropHandle
};
//# sourceMappingURL=PointingCropHandle.mjs.map
